/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import org.openoffice.accessibility.awb.view.ObjectView;

class LayoutManager
implements MouseListener,
MouseMotionListener {
    private JComponent maLayoutedComponent;
    private ObjectView maDraggedView;
    private int mnOldY;
    private boolean mbInsertionPending;
    private Cursor maNormalCursor;

    public LayoutManager(JComponent jComponent) {
        this.maLayoutedComponent = jComponent;
        this.maDraggedView = null;
        this.mbInsertionPending = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        System.out.println(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mnOldY = mouseEvent.getPoint().y;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mbInsertionPending) {
            this.InsertView(this.maDraggedView, mouseEvent.getPoint().y);
            this.mbInsertionPending = false;
            this.maDraggedView = null;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mbInsertionPending) {
            this.InsertView(this.maDraggedView, this.mnOldY);
            this.mbInsertionPending = false;
            this.maDraggedView = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this.mnOldY - mouseEvent.getPoint().y;
        GridBagLayout gridBagLayout = (GridBagLayout)this.maLayoutedComponent.getLayout();
        if (!this.mbInsertionPending && n != 0) {
            this.maDraggedView = this.RemoveView(this.mnOldY);
            if (this.maDraggedView != null) {
                this.mbInsertionPending = true;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private ObjectView RemoveView(int n) {
        ObjectView objectView = null;
        GridBagLayout gridBagLayout = (GridBagLayout)this.maLayoutedComponent.getLayout();
        Point point = gridBagLayout.location(10, n);
        Component[] componentArray = this.maLayoutedComponent.getComponents();
        System.out.println("removing view at " + point);
        for (int i = 0; i < componentArray.length && objectView == null; ++i) {
            GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(componentArray[i]);
            if (gridBagConstraints.gridy != point.y) continue;
            objectView = (ObjectView)componentArray[i];
        }
        this.maNormalCursor = this.maLayoutedComponent.getCursor();
        if (objectView != null) {
            System.out.println("removing view at " + point.y);
            this.maLayoutedComponent.setCursor(new Cursor(13));
            this.maLayoutedComponent.remove(objectView);
            this.maLayoutedComponent.validate();
            this.maLayoutedComponent.repaint();
        }
        return objectView;
    }

    private void InsertView(ObjectView objectView, int n) {
        if (objectView != null) {
            GridBagLayout gridBagLayout = (GridBagLayout)this.maLayoutedComponent.getLayout();
            Point point = gridBagLayout.location(0, n);
            Component[] componentArray = this.maLayoutedComponent.getComponents();
            System.out.println("new position is " + point.y);
            for (int i = 0; i < componentArray.length; ++i) {
                GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(componentArray[i]);
                if (gridBagConstraints.gridy < point.y) continue;
                if (gridBagConstraints.gridy == point.y) {
                    this.maLayoutedComponent.add((Component)this.maDraggedView, gridBagConstraints);
                }
                ++gridBagConstraints.gridy;
                gridBagLayout.setConstraints(componentArray[i], gridBagConstraints);
            }
            this.maLayoutedComponent.validate();
            this.maLayoutedComponent.repaint();
        }
        this.maLayoutedComponent.setCursor(this.maNormalCursor);
    }
}

